* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo: TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2019 - Vehculos Motorizados Matriculados*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin:   05 de Septiembre del 2020*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Gabriela Hidalgo.
* Jorge Len.

*Instrucciones:.
*1.- Descarga la base de datos de Vehculos Matriculados "2019_vehiculos_matriculados_bdd" en formato SPSS de la pgina 
      web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2019_vehiculos_matriculados_bdd".

DATASET NAME VEHICULOS_MATRICULADOS.
DATASET COPY VEHICULOS_MATRICULADOS.
DATASET ACTIVATE VEHICULOS_MATRICULADOS.

**********************************************************************************************************************.
**************TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES*********************.
**********************************************************************************************************************.

COMPUTE VEHICULOS=1.
FORMATS VEHICULOS (F10.0).
VARIABLE LABELS VEHICULOS 'Nmero de vehculos'.
EXECUTE.

***Agregando la base de datos segn provincia**.

DATASET DECLARE VEHICULOS.
AGGREGATE
  /outfile='VEHICULOS'
  /break=PROVINCIA
  /VEHICULOS=SUM(VEHICULOS).

DATASET ACTIVATE VEHICULOS.

VARIABLE LABELS VEHICULOS 'Nmero de vehculos motorizados matriculados'.
FORMATS VEHICULOS (F10.0).
VARIABLE LEVEL VEHICULOS (SCALE).
EXECUTE.

IF (PROVINCIA=1) POBLACION=867239.
IF (PROVINCIA=2) POBLACION=208384.
IF (PROVINCIA=3) POBLACION=276819.
IF (PROVINCIA=4) POBLACION=185523.
IF (PROVINCIA=5) POBLACION=482615.
IF (PROVINCIA=6) POBLACION=519777.
IF (PROVINCIA=7) POBLACION=707204.
IF (PROVINCIA=8) POBLACION=635227.
IF (PROVINCIA=9) POBLACION=4327845.
IF (PROVINCIA=10) POBLACION=470129.
IF (PROVINCIA=11) POBLACION=516231.
IF (PROVINCIA=12) POBLACION=910770.
IF (PROVINCIA=13) POBLACION=1549796.
IF (PROVINCIA=14) POBLACION=192301.
IF (PROVINCIA=15) POBLACION=130976.
IF (PROVINCIA=16) POBLACION=111270.
IF (PROVINCIA=17) POBLACION=3172200.
IF (PROVINCIA=18) POBLACION=584114.
IF (PROVINCIA=19) POBLACION=117899.
IF (PROVINCIA=20) POBLACION=32320.
IF (PROVINCIA=21) POBLACION=225481.
IF (PROVINCIA=22) POBLACION=159479.
IF (PROVINCIA=23) POBLACION=450694.
IF (PROVINCIA=24) POBLACION=392611.
IF (PROVINCIA=25) POBLACION=41082.
EXECUTE.

VARIABLE LABELS POBLACION 'Proyeccin poblacional'.
FORMATS POBLACION (F10.0).
VARIABLE LEVEL POBLACION (SCALE).
EXECUTE.

COMPUTE TMV= (VEHICULOS/(POBLACION/1000)).
FORMATS TMV (F5.0).
VARIABLE LABELS TMV 'Tasa de vehculos matriculados por cada mil habitantes'.
EXECUTE.

SORT CASES BY PROVINCIA (A).


***CUADRO N 15***.

****POR PROVINCIAS****.

TABLES
/OBSERVATION= VEHICULOS POBLACION TMV
/TABLE=PROVINCIA BY VEHICULOS + POBLACION + TMV
/STATISTICS=SUM
/TITLE='CUADRO N 15'
            'VEHCULOS MATRICULADOS POR CADA 1000 HABITANTES, ao 2019'
            'POR PROVINCIAS'
            '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: ANT - Agencia Nacional de Trnsito- 2019' 
                 'INEC - Proyecciones Poblacionales 2019'. 	


DATASET ACTIVATE VEHICULOS_MATRICULADOS.
DATASET CLOSE VEHICULOS.

